# Version 2.10 - 2.11

## "Was" price for JSON output fix
When we prep the Option Paths on product display, we also create a JSON array for the Variants which includes pre-formatted "Was" and "Now" prices. These are often used on the Product page in a JS call which would show the relevant price for each variant depending on what was selected. However, if the variant had a Sale price, the "Was" price would always use the RRP, even if a normal selling price had been entered in to the system. Example:

```
// Admin setup
RRP: 20.00
Price: 18.00
Sale: 15:00

// Product page (no sale)
NOW: 18.00

// Product page (on sale)
WAS: 20.00
NOW: 15.00
```

The example shows the RRP as the "Was" price at 20.00 whereas it should be showing the standard price at 18.00. The changes made in this version corrects this. However, older sites may still want to display it as it was, so a flag has been added which will prefer the RRP when displaying a "Was" price when an item is on sale. This is FALSE by default and should be flipped to TRUE for older sites which may require this.

```
// Prefer RRP when showing the "Was" price on a Sale item
// This is purely a display change and does not affect basket calculations
// FALSE by default, TRUE for older sites which showed the RRP over the Price for the "Was" price
'preferRrpForWasPrice' => false
```

## Additional JSON values
A new JSON value has been added providing a formatted version of the RRP, `rrpFormatted`. This goes alongside the existing `wasPriceFormatted` and `nowPriceFormatted`.
